<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Event extends Model 
{

    protected $table = 'events';
    public $timestamps = true;

    public function Track()
    {
        return $this->hasOne('App\Track', 'Track_id');
    }

    public function Championship()
    {
        return $this->belongsTo('App\Championship', 'championship_id');
    }

    public function Race()
    {
        return $this->hasMany('App\Race');
    }

    public function Practice()
    {
        return $this->hasMany('App\Practice');
    }

}