<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ModelComfort extends Eloquent {

	protected $table = 'model_comforts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function comfort()
	{
		return $this->belongsTo('Comfort', 'comfort_id');
	}

	public function model()
	{
		return $this->hasOne('Model', 'model_id');
	}

}