<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Type extends Model 
{

    protected $table = 'types';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function property_specification()
    {
        return $this->belongsToMany('PropertySpecification', 'type_id');
    }

    public function type()
    {
        return $this->belongsTo('Type', 'type_id');
    }

}