<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ModelComfort extends Model 
{

    protected $table = 'model_comforts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function comfort()
    {
        return $this->belongsTo('Comfort', 'comfort_id');
    }

    public function model()
    {
        return $this->hasOne('Model', 'model_id');
    }

}