<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('formations', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('formations', function(Blueprint $table) {
			$table->foreign('formateur_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_formation', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_formation', function(Blueprint $table) {
			$table->foreign('formation_id')->references('id')->on('formations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('certifications', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('certifications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_certification', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_certification', function(Blueprint $table) {
			$table->foreign('certification_id')->references('id')->on('certifications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_badge', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_badge', function(Blueprint $table) {
			$table->foreign('badge_id')->references('id')->on('badges')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('role')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permission')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('role')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_message', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_message', function(Blueprint $table) {
			$table->foreign('message_id')->references('id')->on('messages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('formations', function(Blueprint $table) {
			$table->dropForeign('formations_category_id_foreign');
		});
		Schema::table('formations', function(Blueprint $table) {
			$table->dropForeign('formations_formateur_id_foreign');
		});
		Schema::table('user_formation', function(Blueprint $table) {
			$table->dropForeign('user_formation_user_id_foreign');
		});
		Schema::table('user_formation', function(Blueprint $table) {
			$table->dropForeign('user_formation_formation_id_foreign');
		});
		Schema::table('certifications', function(Blueprint $table) {
			$table->dropForeign('certifications_category_id_foreign');
		});
		Schema::table('user_certification', function(Blueprint $table) {
			$table->dropForeign('user_certification_user_id_foreign');
		});
		Schema::table('user_certification', function(Blueprint $table) {
			$table->dropForeign('user_certification_certification_id_foreign');
		});
		Schema::table('user_badge', function(Blueprint $table) {
			$table->dropForeign('user_badge_user_id_foreign');
		});
		Schema::table('user_badge', function(Blueprint $table) {
			$table->dropForeign('user_badge_badge_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_role_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_permission_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_role_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_user_id_foreign');
		});
		Schema::table('user_message', function(Blueprint $table) {
			$table->dropForeign('user_message_user_id_foreign');
		});
		Schema::table('user_message', function(Blueprint $table) {
			$table->dropForeign('user_message_message_id_foreign');
		});
	}
}