<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('order_id')->unsigned();
			$table->string('payment_id');
			$table->string('payment_method');
			$table->integer('amount')->unsigned()->default('0');
			$table->timestamp('payment_date');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}