<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDrugsTable extends Migration {

	public function up()
	{
		Schema::create('drugs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->integer('din');
			$table->string('drug_name');
			$table->string('prescription_id');
			$table->string('dosage');
			$table->integer('qty');
			$table->float('cost');
			$table->integer('comment_id')->unsigned()->nullable();
			$table->integer('refil_count')->default('0');
			$table->integer('opted_out')->nullable()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('drugs');
	}
}