<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Theme extends Eloquent {

	protected $table = 'themes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('year_subject_id');

	public function year_subject()
	{
		return $this->belongsTo('Yearsubject');
	}

	public function exercises()
	{
		return $this->hasMany('Exercise');
	}

	public function links()
	{
		return $this->hasMany('Link');
	}

}