<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateKeywordsTable extends Migration {

	public function up()
	{
		Schema::create('keywords', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('parent_id')->unsigned()->nullable();
			$table->string('name', 128);
			$table->string('description', 1024);
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('verified')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('keywords');
	}
}