<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('email', 255)->unique()->nullable();
			$table->string('password', 255)->nullable();
			$table->string('nickname', 255);
			$table->boolean('gender_id')->default(0);
			$table->bigInteger('father_id')->unsigned()->nullable();
			$table->bigInteger('mother_id')->nullable();
			$table->bigInteger('parent_id')->nullable();
			$table->date('dob')->nullable();
			$table->date('yob')->nullable();
			$table->tinyInteger('birth_order')->unsigned()->nullable();
			$table->date('dod')->nullable();
			$table->date('yod')->nullable();
			$table->string('address', 255)->nullable();
			$table->string('city', 255)->nullable();
			$table->string('phone', 255)->nullable();
			$table->string('photo_path', 255)->nullable();
			$table->bigInteger('manager_id')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}