<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TwitterAccount extends Eloquent {

	protected $table = 'twitter_accounts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function contents()
	{
		return $this->hasMany('TwitterContent');
	}

	public function source()
	{
		return $this->belongsTo('Source');
	}

}