<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FluxGroup extends Eloquent {

	protected $table = 'flux_groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function image()
	{
		return $this->hasOne('Image');
	}

	public function fluxes()
	{
		return $this->belongsToMany('Flux');
	}

}