<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Flux extends Eloquent {

	protected $table = 'fluxes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function image()
	{
		return $this->hasOne('Image');
	}

	public function users()
	{
		return $this->belongsToMany('User');
	}

	public function groups()
	{
		return $this->belongsToMany('FluxGroup');
	}

}