<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRssContentsTable extends Migration {

	public function up()
	{
		Schema::create('rss_contents', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('source_id')->unsigned();
			$table->string('title')->nullable();
			$table->text('link');
			$table->text('image_url')->nullable();
			$table->datetime('publication_date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('rss_contents');
	}
}