<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSmsItemsTable extends Migration {

	public function up()
	{
		Schema::create('sms_items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('receiver_id')->unsigned()->nullable();
			$table->string('message', 1000)->nullable();
			$table->string('extra_numbers', 255)->nullable();
			$table->string('sender', 30)->nullable();
			$table->timestamp('scheduled_time')->nullable();
			$table->enum('status', array(''));
			$table->bigInteger('return_id')->nullable();
			$table->integer('delivery_code')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sms_items');
	}
}