<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLogErrorsTable extends Migration {

	public function up()
	{
		Schema::create('log_errors', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('ip', 20)->nullable();
			$table->string('url', 2000)->nullable();
			$table->text('message')->nullable();
			$table->text('stack')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('log_errors');
	}
}