<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLogAccessesTable extends Migration {

	public function up()
	{
		Schema::create('log_accesses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('controller', 100)->nullable();
			$table->string('action', 255)->nullable();
			$table->string('ip_address', 20)->nullable();
			$table->string('url', 2000)->nullable();
			$table->string('description', 1000)->nullable();
			$table->string('content', 4000)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('log_accesses');
	}
}