<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->float('price');
			$table->enum('duration_type', array('day', 'week', 'month', 'year'));
			$table->integer('duration');
			$table->integer('max_usage');
			$table->integer('qty');
			$table->json('features');
			$table->string('icon');
			$table->integer('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}