<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100);
			$table->string('email', 100);
			$table->string('password', 191);
			$table->string('phone');
			$table->json('bio');
			$table->enum('status', array('pending', 'approved', 'completed'));
			$table->string('lat');
			$table->string('lng');
			$table->string('address');
			$table->string('city_id');
			$table->string('place_id');
			$table->string('gallary');
			$table->string('commercial_registration');
			$table->string('vat_registration');
			$table->string('sports_license');
			$table->string('logo');
			$table->string('banner');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}