<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSlidersTable extends Migration {

	public function up()
	{
		Schema::create('sliders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('slug', 191)->unique();
			$table->text('description')->nullable();
			$table->text('link')->nullable();
			$table->string('btn_text', 191)->nullable();
			$table->string('target', 191)->nullable();
			$table->integer('created_by')->nullable();
			$table->datetime('from_date')->nullable();
			$table->datetime('to_date')->nullable();
			$table->boolean('status')->default(0);
			$table->boolean('is_home')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('sliders');
	}
}