<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHomeFeatureItemsTable extends Migration {

	public function up()
	{
		Schema::create('home_feature_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('weblink_id')->unsigned();
			$table->text('image')->nullable();
			$table->string('name', 191)->nullable();
			$table->text('description')->nullable();
			$table->text('link')->nullable();
			$table->integer('created_by')->unsigned();
			$table->boolean('status')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('home_feature_items');
	}
}