<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGalleryTable extends Migration {

	public function up()
	{
		Schema::create('gallery', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('slug', 191)->unique();
			$table->text('description')->nullable();
			$table->tinyInteger('home_page')->nullable();
			$table->tinyInteger('created_by')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('gallery');
	}
}