<?php

namespace app;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function author()
	{
		return $this->belongsTo('app\User');
	}

	public function status()
	{
		return $this->morphToMany('app\Statusable');
	}

}