<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CountryRole extends Model 
{

    protected $table = 'country_roles';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id');

    public function country()
    {
        return $this->belongsTo('Models\Country');
    }

    public function countryPermissions()
    {
        return $this->hasMany('Models\CountryPermission');
    }

}