<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountryAdminsTable extends Migration {

	public function up()
	{
		Schema::create('country_admins', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 191);
			$table->bigInteger('country_id')->unsigned();
			$table->bigInteger('country_role_id')->unsigned();
			$table->string('country_code', 191);
			$table->string('phone', 191)->unique()->nullable();
			$table->string('email', 191)->unique()->nullable();
			$table->string('password', 191);
			$table->string('image', 191)->nullable();
			$table->boolean('active')->default(0);
			$table->boolean('block')->default(0);
			$table->enum('type', array('master', 'admin'));
		});
	}

	public function down()
	{
		Schema::drop('country_admins');
	}
}