<?php

namespace media;

use Illuminate\Database\Eloquent\Model;

class Media extends Model 
{

    protected $table = 'medias';
    public $timestamps = true;

    public function media_type()
    {
        return $this->hasOne('Media_type');
    }

    public function artist()
    {
        return $this->belongsToMany('Artist');
    }

    public function mp3()
    {
        return $this->hasMany('Mp3');
    }

    public function fan_cover()
    {
        return $this->hasMany('Fan_cover');
    }

    public function fan_comment()
    {
        return $this->hasMany('Fan_comment');
    }

    public function fan_rate()
    {
        return $this->hasMany('Fan_rate');
    }

    public function cd_type()
    {
        return $this->hasOne('Cd_type');
    }

}