<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMediasTable extends Migration {

	public function up()
	{
		Schema::create('medias', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->integer('media_type_id')->unsigned();
			$table->integer('cd_type_id')->unsigned();
			$table->date('year');
			$table->string('cover');
			$table->text('info');
			$table->string('length')->nullable();
			$table->string('label')->nullable();
			$table->string('tracklist')->nullable();
			$table->string('amazon')->nullable();
			$table->boolean('display');
		});
	}

	public function down()
	{
		Schema::drop('medias');
	}
}