<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTbGoodsTable extends Migration {

	public function up()
	{
		Schema::create('tb_goods', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('weight')->unsigned();
			$table->integer('count')->unsigned();
			$table->string('id_airway');
			$table->integer('id_payment')->unsigned();
			$table->integer('id_type')->unsigned();
			$table->integer('id_room')->unsigned();
			$table->timestamps();
			$table->string('btb');
			$table->string('origin');
			$table->string('destination');
			$table->string('desc');
			$table->string('dimension');
			$table->string('volume');
			$table->string('price');
			$table->enum('status', array('false', 'true'));
		});
	}

	public function down()
	{
		Schema::drop('tb_goods');
	}
}