<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePurchaseLinesTable extends Migration {

	public function up()
	{
		Schema::create('purchase_lines', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('purchase_id')->unsigned();
			$table->integer('product_id')->unsigned();
			$table->string('description');
			$table->integer('vendor_quantity');
			$table->decimal('vendor_cost', 16,8);
			$table->integer('quantity');
			$table->integer('quantity_unit_id')->unsigned();
			$table->decimal('purchase_cost', 16,8);
			$table->decimal('inventory_cost', 16,8);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('purchase_lines');
	}
}