<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductUnitsTable extends Migration {

	public function up()
	{
		Schema::create('product_units', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned();
			$table->integer('unit_type_id')->unsigned();
			$table->decimal('price', 10,2)->nullable();
			$table->integer('contains_unit_id')->unsigned()->nullable();
			$table->integer('contains_quantity')->nullable();
			$table->decimal('weight', 8,2)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product_units');
	}
}