<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('company')->nullable();
			$table->string('firstname');
			$table->string('lastname');
			$table->string('address');
			$table->string('city');
			$table->string('state');
			$table->string('zipcode');
			$table->string('phone')->nullable();
			$table->string('fax')->nullable();
			$table->string('email');
			$table->enum('def_pay_method', array('CashonDelivery', 'Check', 'MoneyOrder', 'MonthCharge', 'TempCharge', 'CreditCard'))->nullable();
			$table->string('tax_id')->nullable();
			$table->boolean('active');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}