<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Vendor extends Eloquent {

	protected $table = 'vendors';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function purchases()
	{
		return $this->hasMany('App\Purchase', 'vendor_id');
	}

	public function product_units()
	{
		return $this->belongsToMany('App\ProductUnit', 'vendor_product', 'vendor_id', 'product_unit_id')->withPivot('name','model','cost','created_at','updated_at');
	}

}