<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Purchase extends Eloquent {

	protected $table = 'purchases';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function vendor()
	{
		return $this->belongsTo('App\Vendor', 'vendor_id');
	}

	public function lines()
	{
		return $this->hasMany('App\PurchaseLine', 'purchase_id');
	}

}