<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderLine extends Eloquent {

	protected $table = 'order_lines';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function product()
	{
		return $this->belongsTo('App\Product', 'product_id');
	}

	public function unit()
	{
		return $this->belongsTo('App\ProductUnit', 'quantity_unit_id');
	}

	public function order()
	{
		return $this->belongsTo('App\Order', 'order_id');
	}

}