<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function payments()
	{
		return $this->hasMany('App\OrderPayment', 'order_id');
	}

	public function lines()
	{
		return $this->hasMany('App\OrderLine', 'order_id');
	}

	public function customer()
	{
		return $this->belongsTo('App\Customer', 'customer_id');
	}

}