<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('phones', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('employee_qualification', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('employee_qualification', function(Blueprint $table) {
			$table->foreign('qualification_id')->references('id')->on('qualifications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job_history', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job_history', function(Blueprint $table) {
			$table->foreign('job_function_id')->references('id')->on('job_functions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job_history', function(Blueprint $table) {
			$table->foreign('financial_degree_id')->references('id')->on('financial_degrees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job_history', function(Blueprint $table) {
			$table->foreign('job_style_id')->references('id')->on('job_styles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job_history', function(Blueprint $table) {
			$table->foreign('nomination_type_id')->references('id')->on('nomination_types')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('job_functions', function(Blueprint $table) {
			$table->foreign('sub_group_id')->references('id')->on('sub_groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('childrens', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('residence_address', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('languages', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sub_groups', function(Blueprint $table) {
			$table->foreign('functional_group_id')->references('id')->on('functional_groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('phones', function(Blueprint $table) {
			$table->dropForeign('phones_employee_id_foreign');
		});
		Schema::table('employee_qualification', function(Blueprint $table) {
			$table->dropForeign('employee_qualification_employee_id_foreign');
		});
		Schema::table('employee_qualification', function(Blueprint $table) {
			$table->dropForeign('employee_qualification_qualification_id_foreign');
		});
		Schema::table('job_history', function(Blueprint $table) {
			$table->dropForeign('job_history_employee_id_foreign');
		});
		Schema::table('job_history', function(Blueprint $table) {
			$table->dropForeign('job_history_job_function_id_foreign');
		});
		Schema::table('job_history', function(Blueprint $table) {
			$table->dropForeign('job_history_financial_degree_id_foreign');
		});
		Schema::table('job_history', function(Blueprint $table) {
			$table->dropForeign('job_history_job_style_id_foreign');
		});
		Schema::table('job_history', function(Blueprint $table) {
			$table->dropForeign('job_history_nomination_type_id_foreign');
		});
		Schema::table('job_functions', function(Blueprint $table) {
			$table->dropForeign('job_functions_sub_group_id_foreign');
		});
		Schema::table('childrens', function(Blueprint $table) {
			$table->dropForeign('childrens_employee_id_foreign');
		});
		Schema::table('residence_address', function(Blueprint $table) {
			$table->dropForeign('residence_address_employee_id_foreign');
		});
		Schema::table('languages', function(Blueprint $table) {
			$table->dropForeign('languages_employee_id_foreign');
		});
		Schema::table('sub_groups', function(Blueprint $table) {
			$table->dropForeign('sub_groups_functional_group_id_foreign');
		});
	}
}