<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobHistoryTable extends Migration {

	public function up()
	{
		Schema::create('job_history', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->datetime('date');
			$table->bigInteger('employee_id')->unsigned();
			$table->bigInteger('job_function_id')->unsigned();
			$table->bigInteger('financial_degree_id')->unsigned();
			$table->datetime('degree_date');
			$table->bigInteger('job_style_id')->unsigned();
			$table->enum('cadre', array('public', 'private'));
			$table->enum('job_status', array('working', 'notworking'));
			$table->bigInteger('nomination_type_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('job_history');
	}
}