<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('email', 'phone', 'password', 'name', 'area_id', 'is_active');

	public function area()
	{
		return $this->belongsTo('App\Models\Area');
	}

	public function reviews()
	{
		return $this->hasMany('App\Models\Review');
	}

	public function notifcations()
	{
		return $this->morphMany('App\Models\Notification');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

}