<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchesTable extends Migration {

	public function up()
	{
		Schema::create('branches', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->string('address')->nullable();
			$table->string('city')->nullable();
			$table->string('state')->nullable();
			$table->float('lat', 10,6)->nullable();
			$table->float('lng', 10,6)->nullable();
			$table->string('mobile')->nullable();
			$table->tinyInteger('delivery_method')->nullable();
			$table->tinyInteger('is_active')->default('0');
			$table->tinyInteger('status')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('branches');
	}
}