<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCentreTable extends Migration {

	public function up()
	{
		Schema::create('centre', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('nom')->unique();
			$table->string('code')->unique();
			$table->string('arrete_creation')->nullable();
			$table->string('date_creation')->nullable();
			$table->double('latitude')->nullable();
			$table->double('longitude')->nullable();
			$table->integer('user_id')->unsigned()->index();
			$table->string('localisation')->nullable();
			$table->string('addresse_geo')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('centre');
	}
}