<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoryTable extends Migration {

	public function up()
	{
		Schema::create('category', function(Blueprint $table) {
			$table->increments('category_id');
			$table->string('category_name', 255);
			$table->text('category_description');
			$table->string('url', 255);
			$table->enum('status', array('Active', 'Deleted'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('category');
	}
}