<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBrandTable extends Migration {

	public function up()
	{
		Schema::create('brand', function(Blueprint $table) {
			$table->increments('brand_id');
			$table->string('brand_name', 255);
			$table->string('brand_description', 255);
			$table->string('url', 255);
			$table->enum('status', array('Active', 'Deleted'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('brand');
	}
}