<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstitutionsTable extends Migration {

	public function up()
	{
		Schema::create('institutions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->string('namespace')->unique();
			$table->enum('status', array('unsubscribed', 'subscribed', 'expired', 'deleted'));
			$table->json('metadata')->nullable()->default('[]');
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->timestamps();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('institutions');
	}
}