<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountsTable extends Migration {

	public function up()
	{
		Schema::create('accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('vendor', 128);
			$table->json('metadata');
			$table->integer('institution_id')->unsigned();
			$table->integer('created_by')->unsigned()->nullable();
			$table->timestamps();
			$table->integer('updated_by')->unsigned()->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('accounts');
	}
}