<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('institutions', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('institutions', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('plans', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('plans', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('institution_id')->references('id')->on('institutions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->foreign('institution_id')->references('id')->on('institutions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->foreign('captured_ad')->references('id')->on('ads')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->foreign('institution_id')->references('id')->on('institutions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('lead_id')->references('id')->on('leads')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('institution_id')->references('id')->on('institutions')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('institution_id')->references('id')->on('institutions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('sets', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('sets', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('templates', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('templates', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('ads', function(Blueprint $table) {
			$table->foreign('template_id')->references('id')->on('templates')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('ads', function(Blueprint $table) {
			$table->foreign('set_id')->references('id')->on('sets')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('ads', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('ads', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_updated_by_foreign');
		});
		Schema::table('institutions', function(Blueprint $table) {
			$table->dropForeign('institutions_created_by_foreign');
		});
		Schema::table('institutions', function(Blueprint $table) {
			$table->dropForeign('institutions_updated_by_foreign');
		});
		Schema::table('plans', function(Blueprint $table) {
			$table->dropForeign('plans_created_by_foreign');
		});
		Schema::table('plans', function(Blueprint $table) {
			$table->dropForeign('plans_updated_by_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_institution_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_updated_by_foreign');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->dropForeign('groups_institution_id_foreign');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->dropForeign('groups_created_by_foreign');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->dropForeign('groups_updated_by_foreign');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->dropForeign('leads_captured_ad_foreign');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->dropForeign('leads_institution_id_foreign');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->dropForeign('leads_created_by_foreign');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->dropForeign('leads_updated_by_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_lead_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_created_by_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_updated_by_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_user_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_institution_id_foreign');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->dropForeign('invites_created_by_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_institution_id_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_created_by_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_updated_by_foreign');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_created_by_foreign');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_updated_by_foreign');
		});
		Schema::table('sets', function(Blueprint $table) {
			$table->dropForeign('sets_created_by_foreign');
		});
		Schema::table('sets', function(Blueprint $table) {
			$table->dropForeign('sets_updated_by_foreign');
		});
		Schema::table('templates', function(Blueprint $table) {
			$table->dropForeign('templates_created_by_foreign');
		});
		Schema::table('templates', function(Blueprint $table) {
			$table->dropForeign('templates_updated_by_foreign');
		});
		Schema::table('ads', function(Blueprint $table) {
			$table->dropForeign('ads_template_id_foreign');
		});
		Schema::table('ads', function(Blueprint $table) {
			$table->dropForeign('ads_set_id_foreign');
		});
		Schema::table('ads', function(Blueprint $table) {
			$table->dropForeign('ads_campaign_id_foreign');
		});
		Schema::table('ads', function(Blueprint $table) {
			$table->dropForeign('ads_account_id_foreign');
		});
	}
}