<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLeadsTable extends Migration {

	public function up()
	{
		Schema::create('leads', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->json('metadata')->default('[]');
			$table->string('status')->nullable();
			$table->integer('captured_ad')->unsigned()->nullable();
			$table->integer('institution_id')->unsigned();
			$table->integer('created_by')->unsigned()->nullable();
			$table->timestamps();
			$table->integer('updated_by')->unsigned()->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('leads');
	}
}