<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSchedulesTable extends Migration {

	public function up()
	{
		Schema::create('schedules', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('year_id')->unsigned();
			$table->bigInteger('month_id')->unsigned();
			$table->string('day');
			$table->bigInteger('start_time_id')->unsigned();
			$table->bigInteger('end_time_id')->unsigned();
			$table->bigInteger('activity_id')->unsigned();
			$table->string('description');
			$table->string('assignable_type');
			$table->string('assignable_id');
			$table->tinyInteger('is_request');
			$table->tinyInteger('is_approved');
		});
	}

	public function down()
	{
		Schema::drop('schedules');
	}
}