<?php

namespace concurso;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Concurso extends Model 
{

    protected $table = 'concursos';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function participantes()
    {
        return $this->hasMany('Participante', 'id_concurso');
    }

    public function evento()
    {
        return $this->hasOne('Evento');
    }

    public function premios()
    {
        return $this->hasMany('Premio', 'id_concurso');
    }

}