<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEpicesTable extends Migration {

	public function up()
	{
		Schema::create('epices', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_category')->unsigned();
			$table->timestamps();
			$table->string('name', 255);
			$table->text('short_description');
			$table->text('description');
			$table->integer('number');
			$table->string('image_url', 255);
			$table->float('price');
			$table->smallInteger('stock')->default('0');
			$table->string('guid', 255)->nullable();
			$table->integer('id_tax')->unsigned();
			$table->boolean('status')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('epices');
	}
}