<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInnovatorsTable extends Migration {

	public function up()
	{
		Schema::create('innovators', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('country_id')->unsigned()->nullable();
			$table->string('city');
			$table->string('title');
			$table->string('name');
			$table->string('organization_name');
			$table->string('website_link');
			$table->string('country_code');
			$table->string('whatsapp');
			$table->string('linkedin');
			$table->string('profile_image');
			$table->string('cv');
			$table->string('presentation_video');
			$table->string('is_accepted')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('innovators');
	}
}